# Factorial — Iterative vs Recursive vs BigInteger (Java)

## 1) Objective

Compute **n! (factorial)** using three approaches and compare them:

- **Iterative** using `long`: multiplies from 1 to n.
- **Recursive** using `long`: defines `fact(n)` in terms of `fact(n-1)`.
- **Accurate iterative** using **`BigInteger`** to avoid overflow for larger n.

> Class demo reference: `factIter(int n)`, `factRec(int n)`, and `factAcc(int n)` from `Main`. The program loops until the user enters **-1**.

---

## 2) Tracing the recursive solution for n = 0, 1, 2

We use the definition implemented in class:

```java
long factRec(int n) {
  if (n == 0) return 1;          // base case
  return n * factRec(n - 1);     // recursive step
}
```

### n = 0

- Call: `factRec(0)`
- Hits **base case** → returns **1** immediately.

### n = 1

- Call: `factRec(1)`

  - Needs `1 * factRec(0)`
  - `factRec(0)` → base case → **1**
  - Total: **1 \* 1 = 1**

### n = 2

- Call: `factRec(2)`

  - Needs `2 * factRec(1)`
  - `factRec(1)` needs `1 * factRec(0)`

    - `factRec(0)` → base case → **1**
    - `factRec(1)` returns **1 \* 1 = 1**

  - `factRec(2)` returns **2 \* 1 = 2**

Call stack view for n = 2:

```
factRec(2)
  → 2 * factRec(1)
            → 1 * factRec(0)
                        → 1
```

---

## 3) Time & Space Complexity (and correctness limits)

### Iterative with `long` (`factIter`)

- **Time:** `O(n)` — one loop with n multiplications.
- **Space:** `O(1)` — constant extra memory.
- **Overflow note:** `long` overflows at **n ≥ 21** (since `20!` fits in signed 64-bit; `21!` does not). Results beyond that are incorrect due to overflow.

### Recursive with `long` (`factRec`)

- **Time:** `O(n)` — one recursive call per decrement.
- **Space:** `O(n)` — call stack depth n (Java has no guaranteed tail-call optimization).
- **Overflow:** same as iterative `long` (incorrect for **n ≥ 21**), plus the risk of `StackOverflowError` for very large n.

---

## 4) Anatomy of a recursive solution (Reminder)

A solid recursive method includes:

- **Base case:** smallest input handled directly (here: `n == 0 → 1`).
- **Recursive step:** reduce to a smaller subproblem (here: `n * factRec(n - 1)`).
- **Progress guarantee:** each call approaches the base case (n decreases by 1).
- **Input assumptions/validation:** factorial is defined for **n ≥ 0**. In the demo, **-1** is a sentinel value; in practice, validate and reject negatives.
